//
//  MCReportAbstractQueryProcessor.h
//  MCApplication
//
//  Created by Alykhan Jetha on Thu Jul 31 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

@class MCReportCenter, MCPDatabaseConnection;

/*
	A QueryProcessor is a transiant object that does special work for a report center. It's purpose is to gather objects that meet the criteria of the report. Those objects are then passed to a post query processor for output.
	A QueryProcessor is retained by the creating ReportCenter. It is autoreleased after the QueryProcessor calls the ReportCenter back. This gives the QueryProcessor the ability to do some non-modal stuff (sheet for example).

*/

@interface MCReportAbstractQueryProcessor : NSObject {

	MCReportCenter					*reportCenter;  // not retained
	id								queryResults;
	id								error;
}

// designated initializer
- (id)initWithReportCenter:(MCReportCenter *)rc;

// do the work
- (void)processQuery;

// return any errors (if call back return no)
- (id)queryError;

// objects ... could be any array or simply a root/master object
- (id)queryResults;
- (void)setQueryResults:(id)res;

@end
